/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.sysinfo;

import com.ibm.hwmca.base.sysinfo.SysInfoConstants;
import com.ibm.hwmca.base.sysinfo.SysInfoEcData;
import com.ibm.hwmca.base.sysinfo.SysInfoEcInternalCodeData;
import com.ibm.hwmca.base.sysinfo.SysInfoErrorIds;
import com.ibm.hwmca.base.sysinfo.SysInfoMclData;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.sysinfo.SysInfoData;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.List;
import java.util.ResourceBundle;

public class SysInfoEcBean
extends PanelBean
implements SysInfoErrorIds,
SysInfoConstants {
    private static final String TRACE_MASKT = "HSYIEBNT";
    private static final String TRACE_MASKF = "HSYIEBNF";
    private static final String TRACE_MASKD = "HSYIEBND";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-53, "SysInfoEcBean");
    SysInfoEcInternalCodeData internalCodeData;
    private String m_sValueEdit;
    private String m_sKeyEdit;
    private String m_sSysInfoMachineName;
    private ActionDescriptor[] m_adSystemInfoMenu;
    private String m_sTypeOutput;
    private String m_sModelNumberOutput;
    private String m_sSerialNumberOutput;
    private String m_sDriverOutput;
    private String m_sCommunicationStatusOutput;
    private ItemDescriptor[] m_idCodeChangeInfoTable;
    private ColumnDescriptor[] m_cdCodeChangeInfoTableStructure;
    private int[] m_iCodeChangeInfoTableSelection;
    private String[] m_sSysInfoInternalCodeData;
    public static final int NUMBER_COLUMNS = 8;
    int ecCount;

    public SysInfoEcBean() {
        Trace.trace(TRACE_MASKT, "-> SysInfoEcBean.constructor");
    }

    public SysInfoEcBean(LocalizableText tabName, SysInfoData sysInfoData) {
        Trace.trace(TRACE_MASKT, "SysInfoEcBean(SysInfoData)-->");
        Trace.trace(TRACE_MASKD, "Setting tab name");
        this.setDisplayableBeanName(tabName);
        Trace.trace(TRACE_MASKD, "Converting SysInfoData to SysInfoEcInternalCodeData");
        this.internalCodeData = (SysInfoEcInternalCodeData)sysInfoData;
        this.ecCount = this.internalCodeData.getCount();
        if (this.internalCodeData.isEcValid()) {
            Trace.trace(TRACE_MASKF, "internalCodeData.isEcValid == TRUE");
        } else {
            Trace.trace(TRACE_MASKF, "internalCodeData.isEcValid == FALSE");
        }
        Trace.trace(TRACE_MASKF, "!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!");
        Trace.trace(TRACE_MASKF, "NUMBER of EC STREAMS for this target is " + this.ecCount);
        Trace.trace(TRACE_MASKF, "!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!#!");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "<- SysInfoEcBean.panelAction()" + command);
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            if (command.endsWith("DetailsButton")) {
                Trace.trace(TRACE_MASKT, "DETAILS_BUTTON pressed!  gather detail data for this target");
                UserTaskManager utm = (UserTaskManager)event.getSource();
                request.setData("command", command);
                request.setData("panel", "SystemInfoPagePanel");
                if (this.ecCount > 0) {
                    if (this.m_iCodeChangeInfoTableSelection != null) {
                        Trace.trace(TRACE_MASKD, "m_iCodeChangeInfoTableSelection != null");
                        Trace.trace(TRACE_MASKD, "size of m_iCodeChangeInfoTableSelection = " + this.m_iCodeChangeInfoTableSelection.length);
                    } else {
                        Trace.trace(TRACE_MASKD, "m_iCodeChangeInfoTableSelection IS null");
                    }
                    Trace.trace(TRACE_MASKD, "Calling getSelectedRows");
                    int[] rows = utm.getSelectedRows(this.getMountPrefix() + "CodeChangeInfoTable");
                    Trace.trace(TRACE_MASKD, "Back from getSelectedRows");
                    Trace.trace(TRACE_MASKD, "Number of rows = " + rows.length);
                    if (rows.length > 0) {
                        Integer row = new Integer(rows[0]);
                        Trace.trace(TRACE_MASKD, "row selected = " + row);
                        request.setData("row", row);
                        Trace.trace(TRACE_MASKD, "setData " + row);
                        this.postTaskletRequest(request);
                    }
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(logInfo, 40, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoEcBean.panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "SysInfoEcBean.load()-->");
        this.m_adSystemInfoMenu = new ActionDescriptor[0];
        this.m_sTypeOutput = "";
        this.m_sModelNumberOutput = "";
        this.m_sSerialNumberOutput = "";
        this.m_sDriverOutput = "";
        this.m_sCommunicationStatusOutput = "";
        this.m_idCodeChangeInfoTable = new ItemDescriptor[0];
        this.m_iCodeChangeInfoTableSelection = new int[0];
        this.m_cdCodeChangeInfoTableStructure = new ColumnDescriptor[8];
        Trace.trace(TRACE_MASKT, "<- SysInfoEcBean.load()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKF, "SysInfoEcBean.prepare()-->");
        ResourceBundle bundle = ResourceBundle.getBundle("com/ibm/hwmca/base/sysinfo/res/SystemInfoRes");
        this.m_cdCodeChangeInfoTableStructure[0] = new ColumnDescriptor("ECNumberPCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.ECNumberPCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[1] = new ColumnDescriptor("RetrievedLevelCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.RetrievedLevelCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[2] = new ColumnDescriptor("InstallableConcurrentCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.InstallableConcurrentCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[3] = new ColumnDescriptor("InstalledLevelCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.InstalledLevelCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[4] = new ColumnDescriptor("ActivatedLevelCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.ActivatedLevelCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[5] = new ColumnDescriptor("AcceptedLevelCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.AcceptedLevelCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[6] = new ColumnDescriptor("RemovableConcurrentCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.RemovableConcurrentCol.TEXT"), false);
        this.m_cdCodeChangeInfoTableStructure[7] = new ColumnDescriptor("RemovedLevelCol" + this.getMountPrefix(), bundle.getString("SystemInfoPagePanel.RemovedLevelCol.TEXT"), false);
        if (!this.internalCodeData.isEcValid()) {
            Trace.trace(TRACE_MASKF, "internalCodeData.isEcValid is FALSE so Hide structures");
            this.userTaskManager.setShown(this.getMountPrefix() + "InternalCodeChangeInfoGB", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "CodeChangeInfoTable", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "RetrievedLevelCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "InstallableConcurrentCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "InstalledLevelCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "AcceptedLevelCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "ActivatedLevelCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "RemovableConcurrentCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "RemovedLevelCol", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "ECNumberPCol", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DetailsButton", false);
        }
        this.setSysInfo();
        Trace.trace(TRACE_MASKF, "<-- SysInfoEcBean.prepare()");
    }

    private void setSysInfo() {
        Trace.trace(TRACE_MASKT, "SysInfoEcBean.setSysInfo()-->");
        Trace.trace(TRACE_MASKD, "Setting machine information ");
        try {
            Trace.trace(TRACE_MASKD, "Setting machine type ");
            this.setTypeOutput(this.internalCodeData.getMachineType().toString());
            Trace.trace(TRACE_MASKD, "Setting machine model ");
            this.setModelNumberOutput(this.internalCodeData.getMachineModel().toString());
            Trace.trace(TRACE_MASKD, "Setting machine name ");
            this.setMachineName(this.internalCodeData.getMachineName().toString());
            Trace.trace(TRACE_MASKD, "Setting machine SN ");
            this.setSerialNumberOutput(this.internalCodeData.getMachineSerialNumber());
            Trace.trace(TRACE_MASKD, "Setting driver output ");
            String dl = this.internalCodeData.getMachineDriverLevel();
            if (!dl.equals("Not Service Authority")) {
                this.setDriverOutput(dl);
            } else {
                this.userTaskManager.setShown(this.getMountPrefix() + "DriverOutput", false);
            }
            if (this.internalCodeData.isEcValid()) {
                Trace.trace(TRACE_MASKD, "Setting communication status to GOOD");
                LocalizableText commGoodText = new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.goodcomm.status.text");
                this.setCommunicationStatusOutput(commGoodText.toString());
            } else {
                Trace.trace(TRACE_MASKD, "Setting communication status to NO_COMMUNICATION");
                LocalizableText commErrText = new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.noncomm.status.text");
                this.setCommunicationStatusOutput(commErrText.toString());
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(logInfo, 41, hexc).log();
        }
        Trace.trace(TRACE_MASKF, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        Trace.trace(TRACE_MASKF, "number of EC Streams: " + this.ecCount);
        Trace.trace(TRACE_MASKF, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        if (this.ecCount > 0 && this.internalCodeData.isEcValid()) {
            List ecs = this.internalCodeData.getAllSysInfoEcData();
            for (int i = 0; i < this.ecCount; ++i) {
                Trace.trace(TRACE_MASKD, " In loop to set panel table fields index = " + i);
                this.internalCodeData.dumpSysInfoEcData(i);
                SysInfoEcData ec = (SysInfoEcData)ecs.get(i);
                ItemDescriptor[] id = new ItemDescriptor[8];
                Trace.trace(TRACE_MASKD, " Setting item descriptors for index = " + i);
                id[0] = new ItemDescriptor("EC Number" + i + this.getMountPrefix(), ec.getEcNumber().toString());
                Trace.trace(TRACE_MASKD, "Created id[0] = " + id[0]);
                SysInfoMclData mcl = ec.getRetrieveMclData();
                id[1] = new ItemDescriptor("Retrieved Level" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[1] = " + id[1]);
                mcl = ec.getCcpInstallMclData();
                id[2] = new ItemDescriptor("Installable Concurrent" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[2] = " + id[2]);
                mcl = ec.getInstallMclData();
                id[3] = new ItemDescriptor("Installed Level" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[3] = " + id[3]);
                mcl = ec.getActivatedMclData();
                id[4] = new ItemDescriptor("Activated Level" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[4] = " + id[4]);
                mcl = ec.getAcceptedMclData();
                id[5] = new ItemDescriptor("Accepted Level" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[5] = " + id[5]);
                mcl = ec.getCcpRemoveMclData();
                id[6] = new ItemDescriptor("Removeable Concurrent" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[6] = " + id[6]);
                mcl = ec.getRemoveMclData();
                id[7] = new ItemDescriptor("Removed Level" + i + this.getMountPrefix(), mcl.getLevel().toString());
                Trace.trace(TRACE_MASKD, "Created id[7] = " + id[7]);
                this.userTaskManager.addRow(this.getMountPrefix() + "CodeChangeInfoTable", i, id);
                Trace.trace(TRACE_MASKD, "backup from userTaskManager.addRow()");
            }
        } else if (this.internalCodeData.isEcValid()) {
            ItemDescriptor[] id = new ItemDescriptor[8];
            Trace.trace(TRACE_MASKD, " Setting item descriptors for no ec information ");
            LocalizableText noECText = new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.no.ecs.text");
            LocalizableText noDataText = new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.no.data.text");
            id[0] = new ItemDescriptor("EC Number" + this.getMountPrefix(), noECText.toString());
            Trace.trace(TRACE_MASKD, "Created id[0] = " + id[0]);
            id[1] = new ItemDescriptor("Retrieved Level" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[1] = " + id[1]);
            id[2] = new ItemDescriptor("Installable Concurrent" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[2] = " + id[2]);
            id[3] = new ItemDescriptor("Installed Level" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[3] = " + id[3]);
            id[4] = new ItemDescriptor("Activated Level" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[4] = " + id[4]);
            id[5] = new ItemDescriptor("Accepted Level" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[5] = " + id[5]);
            id[6] = new ItemDescriptor("Removeable Concurrent" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[6] = " + id[6]);
            id[7] = new ItemDescriptor("Removed Level" + this.getMountPrefix(), " ");
            Trace.trace(TRACE_MASKD, "Created id[7] = " + id[7]);
            this.userTaskManager.addRow(this.getMountPrefix() + "CodeChangeInfoTable", 0, id);
            Trace.trace(TRACE_MASKD, "backup from userTaskManager.addRow()");
        }
        Trace.trace(TRACE_MASKT, "<-- SysInfoEcBean.setSysInfo()");
    }

    public String getTypeOutput() {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.getMachineType()" + this.m_sTypeOutput);
        return this.m_sTypeOutput;
    }

    public void setTypeOutput(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.setMachineType()" + s);
        this.m_sTypeOutput = s;
    }

    public String getModelNumberOutput() {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.getMachineModel()" + this.m_sModelNumberOutput);
        return this.m_sModelNumberOutput;
    }

    public void setModelNumberOutput(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.setMachineModel()" + s);
        this.m_sModelNumberOutput = s;
    }

    public String getMachineName() {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.getMachineName()" + this.m_sSysInfoMachineName);
        return this.m_sSysInfoMachineName;
    }

    public void setMachineName(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.setMachineName()" + s);
        this.m_sSysInfoMachineName = s;
    }

    public String getSerialNumberOutput() {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.getSerialNumberOutput()" + this.m_sSerialNumberOutput);
        return this.m_sSerialNumberOutput;
    }

    public void setSerialNumberOutput(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.setSerialNumber()" + s);
        this.m_sSerialNumberOutput = s;
    }

    public String getDriverOutput() {
        return this.m_sDriverOutput;
    }

    public void setDriverOutput(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.setDriverOutput()" + s);
        this.m_sDriverOutput = s;
    }

    public String getCommunicationStatusOutput() {
        return this.m_sCommunicationStatusOutput;
    }

    public void setCommunicationStatusOutput(String s) {
        Trace.trace(TRACE_MASKD, " SysInfoEcBean.setCommunicationStatusOutput()" + s);
        this.m_sCommunicationStatusOutput = s;
    }

    public ColumnDescriptor[] getCodeChangeInfoTableRowStructure() {
        return this.m_cdCodeChangeInfoTableStructure;
    }

    public int getCodeChangeInfoTableRowStatus() {
        return 3;
    }

    public int getCodeChangeInfoTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getCodeChangeInfoTableRowAt(int index) {
        return this.m_idCodeChangeInfoTable;
    }

    public void setCodeChangeInfoTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idCodeChangeInfoTable = items;
    }

    public int[] getCodeChangeInfoTableSelection() {
        return this.m_iCodeChangeInfoTableSelection;
    }

    public void setCodeChangeInfoTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iCodeChangeInfoTableSelection = selected;
    }

    public ActionDescriptor[] getSystemInfoMenuList() {
        return this.m_adSystemInfoMenu;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }
}

